(function() {
  //Farmerswife  4/06/2013
  var boundMethodCheck = function(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new Error('Bound instance method accessed before binding'); } };

  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'mobiscroll', 'models/event/EventModel', 'models/time/TimeModel', 'views/objectbrowser/ObjectFolderBrowserView', "views/cfield/CustomFieldView", 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, Mobiscroll, EventModel, TimeModel, ObjectFolderBrowserView, CustomFieldView) {
    var EditTaskView;
    return EditTaskView = class EditTaskView extends Backbone.View {
      constructor() {
        super(...arguments);
        this.__validate = this.__validate.bind(this);
      }

      initialize(usr, obj1, bs, eventsCol, task1, dateSelected) {
        var ref, ref1, ref2;
        this.usr = usr;
        this.obj = obj1;
        this.bs = bs;
        this.eventsCol = eventsCol;
        this.task = task1;
        this.dateSelected = dateSelected;
        this.taskList = this.bs.get('TaskName');
        if (!this.taskList) {
          this.taskList = (ref = this.bs.get(0)) != null ? ref.TaskName : void 0;
        }
        this.statusTaskList = this.bs.get('BookingStatus');
        if (!this.statusTaskList) {
          this.statusTaskList = (ref1 = this.bs.get(0)) != null ? ref1.BookingStatus : void 0;
        }
        this.checkpointTaskList = this.bs.get('BookingStage');
        if (!this.checkpointTaskList) {
          this.checkpointTaskList = (ref2 = this.bs.get(0)) != null ? ref2.BookingStage : void 0;
        }
        if (!this.dateSelected) {
          this.dateSelected = Moment(this.task.get('day'), 'YYYY-MM-DD');
        }
        this.tm = new TimeModel();
        return this.comingFromView = null;
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap #id-btn-done-name': 'btnDoneNameClicked',
          //'tap #id-btn-done-task-status': 'btnDoneStatusClicked'

          //TABS
          'tap .btn-submenu-addtask': 'subMenuAddTaskClicked',
          //SHOWING FORM COMPONENTS
          'tap .edit-request-name': 'btnRequestNameClicked',
          'tap .edit-task-status': 'btnTaskStatusClicked',
          'tap .checkpoint-name': 'btnTaskCheckpointClicked',
          //'tap .edit-request-date' : 'btnRequestDateClicked'
          'tap .edit-request-note': 'btnRequestNoteClicked',
          'tap .edit-involved-extra-info': 'btnInvolvedExtraInfoClicked',
          'tap .edit-involved-note': 'btnInvolvedNoteClicked',
          //SETTING DATE REQUEST
          'tap #btn-input-task-dayIn': 'btnRequestDateTimeClicked',
          'tap #btn-input-task-dayOut': 'btnRequestDateTimeClicked',
          'tap #btn-input-task-timeIn': 'btnRequestDateTimeClicked',
          'tap #btn-input-task-timeOut': 'btnRequestDateTimeClicked',
          'change .time': 'btnTaskDateTimeChanged',
          'change #id-slider-allDay': 'btnAllDayChanged',
          //SETTING REQUEST NAME
          'change input[name=radio-request]': 'btnRadioNameChanged',
          //SETTING TASK STATUS
          'change input[name=radio-task-status]': 'btnRadioStatusChanged',
          //SETTING TASK CHECKPOINT
          'change input[name=radio-task-checkpoint]': 'btnRadioCheckpointChanged',
          //SETTING REQUEST NOTE
          'tap #id-btn-done-note': 'btnDoneNoteClicked',
          //ADD INVOLVED
          'tap #id-btn-addInvolved': 'btnAddTaskInvolvedClicked',
          //'tap .spanTimeEvent' : 'btnTimeInvolvedClicked'
          'tap .btn-timeIN-involved': 'btnTimeInvolvedClicked',
          'tap .btn-timeOUT-involved': 'btnTimeInvolvedClicked',
          'change .input-involved-timein': 'inputTimeInvolvedChanged',
          'change .input-involved-timeout': 'inputTimeInvolvedChanged',
          'change .slider-involved-allday': 'sliderAllDayInvolvedChanged',
          'tap .btn-delete-involved': 'btnDeleteInvolvecClicked',
          'tap .btn-done-note-involved': 'btnDoneNoteInvolvedClicked',
          //SAVING TASK
          'tap #id-btn-save-task': 'btnSaveTaskClicked',
          //DELETING TASK
          'tap #id-btn-delete-task': 'btnDeleteTaskClicked',
          'pageshow': 'pageShown'
        };
      }

      render() {
        var involved, template;
        template = Handlebars.templates['EditTaskView'];
        involved = !_.isArray(this.task.get('Booking').Involved) ? [this.task.get('Booking').Involved] : this.task.get('Booking').Involved;
        this.$el.html(template({
          usr: this.usr.toJSON(),
          task: this.task.toJSON(),
          involved: involved,
          taskList: this.taskList,
          statusTaskList: this.statusTaskList,
          checkpointTaskList: this.checkpointTaskList,
          allDay: this.task.__is_all_day(),
          days_consecutive: this.task.__has_consecutive_days(),
          mainDate: this.dateSelected.format("dddd Do MMMM"),
          year: this.dateSelected.format('YYYY'),
          humanDate: this.dateSelected.calendar(),
          defaultTimeIn: this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime')),
          defaultTimeOut: this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStopTime')),
          daySelected: this.dateSelected.format('DD-MM-YYYY'),
          userMustSelectRequestType: this.usr.__must_select_request_type(),
          legend: this.__generate_legend_html(this.task),
          dayIn: this.task.__get_first_and_last_day(this.dateSelected).dayIn,
          dayOut: this.task.__get_first_and_last_day(this.dateSelected).dayOut
        }));
        this.addSidePanel();
        return this.$el;
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      subMenuAddTaskClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        if (!btn.hasClass('ui-disabled')) {
          id = btn.attr('data-target');
          this.$el.find('.subAddTaskView').hide();
          return $(id).show();
        }
      }

      pageShown() {
        //ADD MYSELF OBJ OR USR AS INVOLVED  IF NO ONE IS IN THERE
        if (this.$el.find('#id-ul-task-involved > li').length === 0) {
          this.print_li_involved(true);
        }
        //# SET CFIELDS TAB
        if (!this.comingFromView) {
          this.__set_cfields_tab();
        }
        //SELECT TAB
        if (this.$el.find('#id-divAddTaskInvolved').is(':visible')) {
          this.$el.find('#id-submenu-addtask-involved').addClass('ui-btn-active');
          return this.$el.find('#id-submenu-addtask-details').removeClass('ui-btn-active');
        } else {
          this.$el.find('#id-submenu-addtask-details').addClass('ui-btn-active');
          return this.$el.find('#id-submenu-addtask-involved').removeClass('ui-btn-active');
        }
      }

      //SHOWING FORMS COMPONENTS
      btnRequestNoteClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.$el.find('.div-request-note-form').toggle();
      }

      btnRequestNameClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.__go_to_name_form();
      }

      btnTaskStatusClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.__go_to_status_form();
      }

      btnTaskCheckpointClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.__go_to_stage_form();
      }

      btnInvolvedNoteClicked(event) {
        var ref, ref1;
        event.stopPropagation();
        event.preventDefault();
        //FIRST HANDLE HELPER 'Tap to edit involved'
        if (((ref = this.$(event.currentTarget).find('.fwi-edit')) != null ? ref.length : void 0) > 0) {
          this.$(event.currentTarget).find('.fwi-edit').addClass('fwi-cross-cancel').removeClass('fwi-edit');
        } else {
          this.$(event.currentTarget).find('.fwi-cross-cancel').addClass('fwi-edit').removeClass('fwi-cross-cancel');
        }
        //SHOW/HIDE   NOTE FORM
        this.$(event.currentTarget).closest('li').find('.note-info').toggle();
        //HIDE EXTRA INFO FORM
        this.$(event.currentTarget).parent().find('.extra-info').hide();
        if (((ref1 = this.$(event.currentTarget).closest('li').find('.edit-involved-extra-info').find('.fwi-cross-cancel')) != null ? ref1.length : void 0) > 0) {
          return this.$(event.currentTarget).closest('li').find('.edit-involved-extra-info').find('.fwi-cross-cancel').addClass('fwi-edit').removeClass('fwi-cross-cancel');
        }
      }

      btnInvolvedExtraInfoClicked(event) {
        var ref;
        event.stopPropagation();
        event.preventDefault();
        // EXTRA INFO ICON
        if (((ref = this.$(event.currentTarget).find('.fwi-edit')) != null ? ref.length : void 0) > 0) {
          this.$(event.currentTarget).find('.fwi-edit').addClass('fwi-cross-cancel').removeClass('fwi-edit');
        } else {
          this.$(event.currentTarget).find('.fwi-cross-cancel').addClass('fwi-edit').removeClass('fwi-cross-cancel');
        }
        //SHOW/HIDE FORM  Extra INFO
        this.$(event.currentTarget).parent().find('.extra-info').toggle();
        if (this.$(event.currentTarget).parent().find('.extra-info').is(':visible')) {
          this.$(event.currentTarget).closest('li').find('.edit-involved-note').hide();
          //NOTE ICON
          this.$(event.currentTarget).closest('li').find('.edit-involved-note').find('.fwi-cross-cancel').addClass('fwi-edit').removeClass('fwi-cross-cancel');
        } else {
          this.$(event.currentTarget).closest('li').find('.edit-involved-note').show();
        }
        //HIDE FORM NOTE
        return this.$(event.currentTarget).closest('li').find('.note-info').hide();
      }

      //SETTING Task DATES
      btnAllDayChanged(event) {
        var btn, status, time, timeIn, timeOut;
        btn = $(event.currentTarget);
        status = btn.val();
        if (status === 'on') { //SETTING ALL DAY TO EVERYTHING
          time = '00:00';
          this.$el.find('#id-input-task-timeIn').val(time);
          this.$el.find('#id-input-task-timeOut').val(time);
          this.$el.find('#id-span-task-timeIn').text(time);
          this.$el.find('#id-span-task-timeOut').text(time);
          this.$el.find('#btn-input-task-timeIn').find('.ui-btn-text').html(time);
          this.$el.find('#btn-input-task-timeOut').find('.ui-btn-text').html(time);
          this.$el.find('#id-p-allDay').show();
          this.$el.find('#id-p-times').hide();
          //HIDE TIMEIN /TIMEOUT
          this.$el.find('.timeButtons').hide();
          //@$el.find('#btn-input-task-timeIn').hide()
          //@$el.find('#btn-input-task-timeOut').hide()
          return this.__set_involved_times(true, time, time);
        } else {
          timeIn = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime'));
          timeOut = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStopTime'));
          this.$el.find('#id-input-task-timeIn').val(timeIn);
          this.$el.find('#id-input-task-timeOut').val(timeOut);
          this.$el.find('#id-span-task-timeIn').text(timeIn);
          this.$el.find('#id-span-task-timeOut').text(timeOut);
          this.$el.find('#btn-input-task-timeIn').find('.ui-btn-text').html(timeIn);
          this.$el.find('#btn-input-task-timeOut').find('.ui-btn-text').html(timeOut);
          this.$el.find('#id-p-allDay').hide();
          this.$el.find('#id-p-times').show();
          //SHOW TIMEIN /TIMEOUT
          this.$el.find('.timeButtons').show();
          return this.__set_involved_times(false, timeIn, timeOut);
        }
      }

      btnRequestDateTimeClicked(event) {
        var curBtn, input, options, timeOptions, type;
        event.stopPropagation();
        event.preventDefault();
        curBtn = $(event.currentTarget);
        input = curBtn.attr('data-target');
        type = curBtn.attr('data-type');
        options = {
          theme: 'iOS',
          display: 'bottom',
          dateFormat: 'dd-mm-yy',
          dateOrder: 'ddmmyy',
          onChange: this.__validate,
          maxDate: window.MAXDATE
        };
        timeOptions = {
          theme: 'iOS',
          display: 'bottom',
          onChange: this.__validate
        };
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          timeOptions['timeFormat'] = 'H:ii';
          timeOptions['timeWheels'] = 'Hii';
        } else {
          timeOptions['timeFormat'] = 'h:ii A';
          timeOptions['timeWheels'] = 'hii A';
        }
        switch (type) {
          case 'DI':
            $(input).mobiscroll().date(options);
            break;
          case 'TI':
            $(input).mobiscroll().time(timeOptions);
            break;
          case 'DO':
            $(input).mobiscroll().date(options);
            break;
          case 'TO':
            $(input).mobiscroll().time(timeOptions);
        }
        return $(input).mobiscroll('show');
      }

      btnTaskDateTimeChanged(event) {
        var btnTarget, dateIn, dateOut, formatStr, formatTime, gap, input, legend, newTo, popUp, popUpHtml, str, ti, to, type;
        //TODO SET TIME PICKER WITH BIGGER DATE INI > OUT    NOT CONSIDERING TIME&DAy ONLY DAY
        input = $(event.currentTarget);
        btnTarget = input.attr('data-target');
        type = $(btnTarget).attr('data-type');
        formatTime = 'h:mm A';
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          formatTime = 'h:mm';
        }
        switch (type) {
          case 'TI':
            str = input.val();
            //# CHECK IF ITS IN SERVER LIMITS FOR STARTING TIME OR NOT
            gap = this.tm.get_float_from_time_string(this.usr.get('dayStartsAt'), str);
            if (gap < 0) {
              input.val(this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime')));
              popUpHtml = `<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" data-dismissible="false" class="ui-corner-all">
<div data-role="header" data-theme="a" class="ui-corner-top">
<h3>Error With Your Initial Time</h3>
</div>
<div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">
<p>You are adding a booking before your day starts, please check your Initial Time<p>
<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpDismiss">Dismiss</a>
</div>
</div>`;
              this.$el.append(popUpHtml);
              popUp = this.$el.find('#popupAlert');
              popUp.popup();
              popUp.trigger('create');
              popUp.popup('open');
              return;
            }
            formatStr = 'H:mm';
            if (_.indexOf(str, 'M') !== -1) { //AMPM CHECK
              formatStr = 'h:mm A';
            }
            ti = Moment(input.val(), formatStr);
            to = Moment(this.$el.find('#id-input-task-timeOut').val(), formatStr);
            newTo = to.format(formatStr);
            if (ti > to) {
              ti.add('m', 15);
              newTo = ti.format(formatStr);
              this.$el.find('#id-input-task-timeOut').val(newTo); //SET TIME OUT INPUT
              this.$el.find('#id-span-task-timeOut').text(newTo); //SET BLUE DIV
              this.$el.find('#btn-input-task-timeOut').find('.ui-btn-text').html(newTo); //SET TIME OUT BUTTON
            }
            
            // SET TIME ON BLUE DIV
            this.$el.find('#id-span-task-timeIn').text(str);
            if (this.$el.find('#id-slider-allDay').val() === 'on') {
              this.$el.find('#id-slider-allDay').val('off');
              this.$el.find('#id-slider-allDay').trigger('change');
            }
            /* SET ALL INVOLVED TIMES TO THIS ONE */
            this.__set_involved_times(false, str, newTo);
            break;
          case 'DI':
            str = input.val();
            dateIn = Moment(input.val(), 'DD-MM-YYYY');
            dateOut = Moment(this.$el.find('#id-input-task-dayOut').val(), 'DD-MM-YYYY');
            if (dateIn > dateOut) {
              this.$el.find('#id-input-task-dayOut').val(str);
              this.$el.find('#id-input-task-dayOut').trigger('change');
            }
            // SET TIME ON BLUE DIV
            this.$el.find('.main-date strong').text(dateIn.format("dddd Do MMMM"));
            this.$el.find('.year').text(dateIn.format("YYYY"));
            this.$el.find('.human-date').text(dateIn.calendar());
            legend = dateIn.format('dddd Do MMMM') + ' - ' + dateOut.format('dddd Do MMMM') + ' (1/' + (dateOut.diff(dateIn, 'days') + 1) + ')';
            //SET TIME LEGEND IF NEEDED
            if (dateOut.diff(dateIn, 'days') > 0) {
              this.$el.find('#id-p-request-legend').text(legend);
            } else {
              this.$el.find('#id-p-request-legend').text('');
            }
            break;
          case 'TO':
            str = input.val();
            // SET TIME ON BLUE DIV
            this.$el.find('#id-span-task-timeOut').text(str);
            if (this.$el.find('#id-slider-allDay').val() === 'on') {
              this.$el.find('#id-slider-allDay').val('off');
              this.$el.find('#id-slider-allDay').trigger('change');
            }
            /* SET ALL INVOLVED TIMES TO THIS ONE */
            this.__set_involved_times(false, this.$el.find('#id-input-task-timeIn').val(), str);
            break;
          case 'DO':
            str = input.val();
            dateIn = Moment(this.$el.find('#id-input-task-dayIn').val(), 'DD-MM-YYYY');
            dateOut = Moment(input.val(), 'DD-MM-YYYY');
            legend = dateIn.format('dddd Do MMMM') + ' - ' + dateOut.format('dddd Do MMMM') + ' (1/' + (dateOut.diff(dateIn, 'days') + 1) + ')';
            // SET TIME LEGEND
            if (dateOut.diff(dateIn, 'days') > 0) {
              this.$el.find('#id-p-request-legend').text(legend);
            } else {
              this.$el.find('#id-p-request-legend').text('');
            }
        }
        return $(btnTarget).find('.ui-btn-text').html(str);
      }

      __validate(date, inst) {
        var dateIn, dateOut, instOut, timeInstOut;
        boundMethodCheck(this, EditTaskView);
        //dayIn  = @$el.find('#id-input-task-dayIn').mobiscroll('getInst')
        instOut = this.$el.find('#id-input-task-dayOut').mobiscroll('getInst');
        timeInstOut = this.$el.find('#id-input-task-timeOut').mobiscroll('getInst');
        if (instOut != null ? instOut.isVisible() : void 0) {
          if (_.indexOf(this.$el.find('#id-input-task-timeOut').val(), 'M') === -1) {
            dateOut = Moment(date + ' ' + this.$el.find('#id-input-task-timeOut').val(), 'DD-MM-YYYY h:mm');
            dateIn = Moment(this.$el.find('#id-input-task-dayIn').val() + ' ' + this.$el.find('#id-input-task-timeIn').val(), 'DD-MM-YYYY h:mm');
          } else {
            dateOut = Moment(date + ' ' + this.$el.find('#id-input-task-timeOut').val(), 'DD-MM-YYYY h:mm A');
            dateIn = Moment(this.$el.find('#id-input-task-dayIn').val() + ' ' + this.$el.find('#id-input-task-timeIn').val(), 'DD-MM-YYYY h:mm A');
          }
          if (dateIn > dateOut) {
            this.$el.find('.dwv').html('<strong>Ini Day > End Day</strong>');
            this.$el.find('.dwbw.dwb-s').hide();
          } else {
            this.$el.find('.dwbw.dwb-s').show();
            return;
          }
        }
        if (timeInstOut != null ? timeInstOut.isVisible() : void 0) {
          if (_.indexOf(timeInstOut.val, 'M') === -1) {
            dateOut = Moment(date, 'H:mm');
            dateIn = Moment(this.$el.find('#id-input-task-timeIn').val(), 'H:mm');
          } else {
            dateOut = Moment(date, 'h:mm A');
            dateIn = Moment(this.$el.find('#id-input-task-timeIn').val(), 'h:mm A');
          }
          if (dateIn > dateOut) {
            this.$el.find('.dwv').html('<strong>Ini Date > End Date</strong>');
            return this.$el.find('.dwbw.dwb-s').hide();
          } else {
            this.$el.find('.dwbw.dwb-s').show();
          }
        }
      }

      //SETTING TASK NOTE
      btnDoneNoteClicked(event) {
        var reqNote;
        event.stopPropagation();
        event.preventDefault();
        reqNote = this.$el.find('#id-input-task-note').val();
        this.$el.find('p.edit-request-note').text(reqNote);
        return this.$el.find('.div-request-note-form').hide();
      }

      //SETTING TASK NAME
      btnRadioNameChanged(event) {
        var radio, reqName;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        reqName = radio.val();
        this.$el.find('p.edit-request-name').text(reqName);
        this.$el.find('#id-input-task-name').val(reqName);
        return this.__go_to_request_form(reqName);
      }

      btnDoneNameClicked(event) {
        var input, reqName;
        event.stopPropagation();
        event.preventDefault();
        input = this.$el.find('#id-input-task-name');
        reqName = input.val();
        this.$el.find('p.edit-request-name').text(reqName);
        return this.__go_to_request_form(reqName);
      }

      //SETTING TASK STATUS
      btnRadioStatusChanged(event) {
        var radio, st;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        st = radio.val();
        this.$el.find('p.edit-task-status').text(st);
        this.$el.find('#id-input-task-status').val(st);
        return this.__go_to_request_form('status');
      }

      //SETTING TASK CHECKPOINT
      btnRadioCheckpointChanged(event) {
        var curClass, newClass, radio, st;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        st = radio.val();
        this.$el.find('span.checkpoint-name').text(st);
        this.$el.find('span.checkpoint-name').attr('data-stageValue', radio.attr('data-stageValue'));
        curClass = this.$el.find('#id-p-checkpoint .fwi-checkpoint').attr('class');
        switch (st) {
          case 'Cancelled':
            newClass = 'fwi-checkpoint checkpoint-cancel';
            break;
          case 'Completed':
            newClass = 'fwi-checkpoint checkpoint-complete';
            break;
          case 'Ignore':
            newClass = 'fwi-checkpoint checkpoint-ignore';
            break;
          case 'In Progress':
            newClass = 'fwi-checkpoint checkpoint-progress';
            break;
          case 'Pending':
            newClass = 'fwi-checkpoint checkpoint-pending';
        }
        this.$el.find('#id-p-checkpoint .fwi-checkpoint').removeClass(curClass).addClass(newClass);
        this.$el.find('#id-input-task-checkpoint').val(st);
        return this.__go_to_request_form();
      }

      //INVOLVED TAB
      print_li_involved(myself, obj) {
        var allDay, allDayHTML, bookingLineID, btnTimeInText, btnTimeOutText, dataTimeIn, dataTimeOut, displayTimeButtons, icon, id, li, name, objClassID, spanHTML, type, ul;
        if (myself) {
          name = this.usr.get('usersFullName');
          id = this.usr.get('usersObjectID');
          type = this.usr.get('usersObjectType');
          objClassID = 'userObjectClassID';
          bookingLineID = 'bookingLineID';
          icon = 'fwi-contact';
        } else {
          name = obj.get('objectName');
          id = obj.get('objectID');
          type = obj.get('objectType');
          objClassID = obj.get('objectClassID');
          bookingLineID = obj.get('bookingLineID');
          icon = obj.__get_object_icon();
        }
        if (this.$el.find('#id-input-task-timeOut').val() === "00:00" && this.$el.find('#id-input-task-timeIn').val() === "00:00") {
          allDay = true;
          allDayHTML = "selected=''";
          displayTimeButtons = 'style="display:none;"';
          dataTimeIn = "00:00";
          dataTimeOut = "00:00";
          btnTimeInText = "Time In";
          btnTimeOutText = "Time Out";
          spanHTML = 'All Day';
        } else {
          allDay = false;
          allDayHTML = '';
          displayTimeButtons = '';
          dataTimeIn = this.$el.find('#id-input-task-timeIn').val();
          dataTimeOut = this.$el.find('#id-input-task-timeOut').val();
          btnTimeInText = "Time In: " + dataTimeIn;
          btnTimeOutText = "Time Out: " + dataTimeOut;
          spanHTML = `<span>${dataTimeIn}</span> / <span>${dataTimeOut}</span>`;
        }
        li = `<li class=\"liBookingInvolved\" data-objectID=\"${id}\" data-objectType=\"${type}\" data-objectClassID=\"${objClassID}\" data-bookingLineID=\"${bookingLineID}\" data-timeIn=\"${dataTimeIn}\" data-timeOut=\"${dataTimeOut}\">`;
        li += `<div class='header edit-involved-extra-info'><span class='spanTimeEventInvolved' id=\"id-spanTimeEvent-${id}\">${spanHTML}</span><span class=\"name ${icon}\" > ${name} </span><span class='fwi-edit'/> </div>`;
        li += " <div class='subheader edit-involved-note'><span class='fwi-edit'/><span class='text'> Tap to edit note </span> </div>";
        li += '<div class="note-info" style="display:none;"><textarea placeholder="Involved Note" ></textarea><span class="btn btn-done-note-involved"> Done Editing Note</span></div>';
        li += '<div class="extra-info" style="display: none;">';
        li += "<div class='div-wrap-timecontrol' data-role='fieldset'>";
        //      li += '<h4>Set Time for Involved</h4>'
        li += `<label for='id-slider-allDay'>All Day </label> <select name=\"allDaySlider-${id}\" id=\"id-slider-allDay-${id}\" class='slider-involved-allday' data-id=\"${id}\" data-role='slider'> <option value='off' ${allDayHTML}>No</option> <option value='on'  ${allDayHTML}>Yes</option> </select>`;
        li += `<div class=\"wrapper-btn-time wrapper-btn-time-${id}\" ${displayTimeButtons}>`;
        li += `<span class=\"btn btn-timeIN-involved\" data-target=\"input-involved-timeIN-${id}\" id=\"id-btn-timeIN-${id}\" data-type='TI'> ${btnTimeInText} </span>`;
        li += `<span class=\"btn btn-timeOUT-involved\" data-target=\"input-involved-timeOUT-${id}\" id=\"id-btn-timeOUT-${id}\" data-type='TO'> ${btnTimeOutText} </span>`;
        li += '</div>';
        li += '<div class="div-wrap"><span class="btn btn-delete-involved"> Delete Involved</span></div>';
        li += `<input type='hidden' class='input-involved-timein' id=\"input-involved-timeIN-${id}\" data-id=\"${id}\" data-type='TI' value=\"${dataTimeIn}\"/><input type='hidden' class='input-involved-timeout' data-type='TO' id=\"input-involved-timeOUT-${id}\" data-id=\"${id}\" value=\"${dataTimeOut}\"/>`;
        li += '</div></li>';
        ul = this.$el.find('#id-ul-task-involved');
        ul.append(li);
        this.$el.find('.extra-info').trigger('create');
        this.$el.find('.note-info').trigger('create');
        ul.listview();
        return ul.listview('refresh');
      }

      btnAddTaskInvolvedClicked(event) {
        var nextView;
        event.stopPropagation();
        event.preventDefault();
        if (!ObjectFolderBrowserView) {
          ObjectFolderBrowserView = require('views/objectbrowser/ObjectFolderBrowserView');
        }
        nextView = new ObjectFolderBrowserView(this.usr, 'TaskInvolved');
        return $.mobile.jqmNavigator.pushView(nextView, {
          transition: 'none'
        });
      }

      addedTaskInvolved(view, objMdl) {
        //console.log objMdl.toJSON()
        //ONLY PRINTING IF NOT ALREADY IN LIST
        //if $("#id-ul-task-involved > li[data-objectid=\"#{objMdl.get('objectID')}\"]").length is 0
        view.print_li_involved(false, objMdl);
        //COMING BACK TO TASK VIEW FROM OBJECT BRWOSER
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnTimeInvolvedClicked(event) {
        /* GETTING DOM ELEMENTS TAKING CARE OF WHICH LI IS BEEN MODIFIED, DUPLICATED INVOVLED AWARENESS NOT USING OBJECT ID */
        var cur, input, inputObj, timeOptions, type;
        event.stopPropagation();
        event.preventDefault();
        cur = $(event.currentTarget);
        input = '#' + cur.attr('data-target');
        type = cur.attr('data-type');
        inputObj = cur.parentsUntil('li').find(input);
        //console.log input

        //options = { theme: 'Android', display: 'bottom', dateFormat:'dd-mm-yy', dateOrder:'ddmmyy'}
        timeOptions = {
          theme: 'Android',
          display: 'bottom'
        };
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          timeOptions['timeFormat'] = 'H:ii';
          timeOptions['timeWheels'] = 'Hii';
        } else {
          timeOptions['timeFormat'] = 'h:ii A';
          timeOptions['timeWheels'] = 'hii A';
        }
        switch (type) {
          case 'TI':
            inputObj.mobiscroll().time(timeOptions);
            break;
          case 'TO':
            inputObj.mobiscroll().time(timeOptions);
        }
        return inputObj.mobiscroll('show');
      }

      sliderAllDayInvolvedChanged(event) {
        /* GETTING DOM ELEMENTS TAKING CARE OF WHICH LI IS BEEN MODIFIED, DUPLICATED INVOVLED AWARENESS NOT USING OBJECT ID */
        var btnTimeIn, btnTimeOut, idInvolved, inputTimeIn, inputTimeOut, li, sel, spanTimeEvent, status, time, timeIn, timeOut, wrapperTimeBtn;
        event.stopPropagation();
        event.preventDefault();
        sel = $(event.currentTarget);
        status = sel.val();
        idInvolved = sel.attr('data-id');
        li = sel.closest('li');
        inputTimeIn = sel.siblings(`#input-involved-timeIN-${idInvolved}`);
        inputTimeOut = sel.siblings(`#input-involved-timeOUT-${idInvolved}`);
        btnTimeIn = sel.siblings().find(`#id-btn-timeIN-${idInvolved}`);
        btnTimeOut = sel.siblings().find(`#id-btn-timeOUT-${idInvolved}`);
        spanTimeEvent = li.find(`#id-spanTimeEvent-${idInvolved}`);
        wrapperTimeBtn = sel.siblings(`.wrapper-btn-time-${idInvolved}`);
        if (status === 'on') { //SETTING ALL DAY TO EVERYTHING
          time = '00:00';
          inputTimeIn.val(time);
          inputTimeOut.val(time);
          spanTimeEvent.text('All Day');
          // SET DATA-TIMES IN LI FOR SAVING
          li.attr("data-timeIN", time);
          li.attr("data-timeOUT", time);
          //HIDE TIMEIN / TIMEOUT
          return wrapperTimeBtn.hide();
        } else {
          if (this.$el.find('#id-slider-allDay').val() === "off") {
            timeIn = this.$el.find('#id-input-task-timeIn').val();
            timeOut = this.$el.find('#id-input-task-timeOut').val();
          } else {
            timeIn = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime'));
            timeOut = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStopTime'));
          }
          inputTimeIn.val(timeIn);
          inputTimeOut.val(timeOut);
          spanTimeEvent.html(`<span>${timeIn}</span> / <span>${timeOut}</span>`);
          btnTimeIn.text("Time In: " + timeIn);
          btnTimeOut.text("Time Out: " + timeOut);
          // SET DATA-TIMES IN LI FOR SAVING
          li.attr("data-timeIN", timeIn);
          li.attr("data-timeOUT", timeOut);
          //HIDE TIMEIN / TIMEOUT
          return wrapperTimeBtn.show();
        }
      }

      inputTimeInvolvedChanged(event) {
        /* GETTING DOM ELEMENTS TAKING CARE OF WHICH LI IS BEEN MODIFIED, DUPLICATED INVOVLED AWARENESS NOT USING OBJECT ID */
        var btnTarget, btnTimeIn, btnTimeOut, formatStr, formatTime, idInvolved, input, inputTimeIn, inputTimeOut, li, newTo, spanTimeEvent, ti, timeStr, to, type;
        input = $(event.currentTarget);
        idInvolved = input.attr('data-id');
        type = input.attr('data-type');
        li = input.closest('li');
        spanTimeEvent = li.find(`#id-spanTimeEvent-${idInvolved}`);
        if (type === 'TI') {
          inputTimeIn = input;
          inputTimeOut = input.siblings(`#input-involved-timeOUT-${idInvolved}`);
        } else {
          inputTimeIn = input.siblings(`#input-involved-timeIN-${idInvolved}`);
          inputTimeOut = input;
        }
        btnTimeIn = input.siblings().find(`#id-btn-timeIN-${idInvolved}`);
        btnTimeOut = input.siblings().find(`#id-btn-timeOUT-${idInvolved}`);
        formatTime = 'h:mm A';
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          formatTime = 'h:mm';
        }
        switch (type) {
          case 'TI':
            timeStr = 'Time In: ' + input.val();
            btnTarget = btnTimeIn;
            formatStr = 'H:mm';
            if (_.indexOf(input.val(), 'M') !== -1) { //AMPM CHECK
              formatStr = 'h:mm A';
            }
            ti = Moment(input.val(), formatStr);
            to = Moment(inputTimeOut.val(), formatStr);
            if (ti > to) {
              ti.add('m', 15);
              newTo = ti.format(formatStr);
              inputTimeOut.val(newTo); //SET TIME OUT INPUT
              btnTimeOut.text('Time Out: ' + newTo); //SET TIME OUT BUTTON
            }
            break;
          case 'TO':
            timeStr = 'Time Out: ' + input.val();
            btnTarget = btnTimeOut;
        }
        //SET BUTTON TEXT
        btnTarget.text(timeStr);
        // SET TIME ON SPAN TIME EVENT
        spanTimeEvent.html(`<span>${inputTimeIn.val()}</span> / <span>${inputTimeOut.val()}</span>`);
        // SET DATA-TIMES IN LI FOR SAVING
        li.attr("data-timeIN", inputTimeIn.val());
        return li.attr("data-timeOUT", inputTimeOut.val());
      }

      btnDoneNoteInvolvedClicked(event) {
        var btn, li, text;
        event.stopPropagation();
        event.preventDefault();
        btn = $(event.currentTarget);
        text = btn.siblings('textarea').val();
        li = btn.closest('li');
        li.find('.edit-involved-note > .text').text(text);
        li.attr('data-involved-note', text);
        //HIDING WRAPER
        btn.parent().hide();
        return li.find('.edit-involved-note > .fwi-cross-cancel ').addClass('fwi-edit').removeClass('fwi-cross-cancel');
      }

      btnDeleteInvolvecClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return $(event.currentTarget).parents('li').remove();
      }

      //SAVING Task
      btnSaveTaskClicked(event) {
        var cur, dateIn, dateOut, diffDays, task;
        if (this.$el.find('.liBookingInvolved').length === 0) {
          this.$el.append('<div data-role="popup" id="popupAlert"> <p>Please add at least one involved to the task.<p> </div>');
          this.$el.find('#popupAlert').popup();
          this.$el.find('#popupAlert').popup('open');
          return;
        }
        event.stopPropagation();
        event.preventDefault();
        task = new Object();
        task.sessionID = this.usr.get('sessionID');
        task.parentType = 'task'; //HARDCODED TYPE OF BOOKING WTF!!!!
        //DAY
        task.day = this.dateSelected.format('YYYY-MM-DD'); //@$el.find('#id-input-task-dayIn').val()
        if (this.$el.find('#id-slider-allDay').val() === 'on') {
          task.timeIn = "0.000000";
          task.timeOut = "24.000000";
        } else {
          //TIME IN  FLOAT
          task.timeIn = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), this.$el.find('#id-input-task-timeIn').val());
          //TIME OUT FLOAT
          task.timeOut = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), this.$el.find('#id-input-task-timeOut').val());
        }
        //OCUR DAYS
        dateIn = Moment(this.$el.find('#id-input-task-dayIn').val(), 'DD-MM-YYYY');
        dateOut = Moment(this.$el.find('#id-input-task-dayOut').val(), 'DD-MM-YYYY');
        diffDays = dateOut.diff(dateIn, 'days');
        if (diffDays > 0) {
          task.occursOnDay = [];
          cur = dateIn;
          while (cur <= dateOut) {
            task.occursOnDay.push(cur.format('YYYY-MM-DD'));
            cur.add('days', 1);
          }
        } else {
          task.occursOnDay = dateIn.format('YYYY-MM-DD');
        }
        //REQ NAME
        task.name = this.$el.find('#id-input-task-name').val();
        //REQ NOTE
        task.note = this.$el.find('#id-input-task-note').val();
        //EDITING TASK
        task.bookingID = this.task.get('Booking').bookingID;
        //STATUS
        task.status = this.$el.find('#id-p-task-status').text();
        task.createdByID = this.task.get('Booking').createdByID;
        //STAGE
        task.stageName = this.$el.find('.checkpoint-name').text();
        task.stageValue = this.$el.find('.checkpoint-name').attr('data-stageValue');
        task.Involved = new Array();
        _.each(this.$el.find('.liBookingInvolved'), (liInv) => {
          var invObj, ref, ref1, timeIn, timeOut;
          if ($(liInv).find('.slider-involved-allday').val() === 'on') {
            timeIn = "0.0000";
            timeOut = "24.000";
          } else {
            timeIn = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), $(liInv).attr('data-timeIn'));
            timeOut = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), $(liInv).attr('data-timeOut'));
            // FORCE ALL DAY
            if (timeIn === 0 && timeOut === 0) {
              timeOut = "24.000";
            }
          }
          invObj = {
            objectID: window.__check_undefined($(liInv).attr('data-objectID')),
            objectType: $(liInv).attr('data-objectType'),
            timeIn: timeIn,
            timeOut: timeOut
          };
          if ($(liInv).attr('data-involved-note')) {
            invObj['note'] = window.html_entities($(liInv).attr('data-involved-note'));
          }
          if ((ref = $(liInv).attr('data-bookingLineID')) !== "bookingLineID" && ref !== "undefined") {
            invObj['bookingLineID'] = $(liInv).attr('data-bookingLineID');
          }
          if ((ref1 = $(liInv).attr('data-objectClassID')) !== "userObjectClassID" && ref1 !== "undefined") {
            invObj['objectClassID'] = $(liInv).attr('data-objectClassID');
          }
          return task.Involved.push(invObj);
        });
        task.CustomField = new Array();
        _.each(this.$el.find('.liBookingCustomField'), function(cf) {
          var cfObj, input, ref, ref1, ref2, type, value;
          type = $(cf).attr('data-type');
          switch (type) {
            case 'checkbox':
              value = $(cf).find('select.selector-checkbox-cfield').val();
              break;
            case 'entry':
              if (((ref = $(cf).find('.selector-company-cfield')) != null ? ref.length : void 0) > 0) {
                value = $((ref1 = $(cf).find('span.selector-company-cfield')) != null ? ref1[0] : void 0).text();
              } else if (((ref2 = $(cf).find('.btn-contact-cfield')) != null ? ref2.length : void 0) > 0) {
                value = $(cf).find('.btn-contact-cfield').text();
              } else {
                value = $(cf).find('.entry-cfield').val();
              }
              break;
            case 'text':
              value = $(cf).find('.text-cfield').val();
              break;
            case 'selector':
              input = $(cf).find('.input-selector-cfield').val();
              if (input) {
                value = input;
              } else {
                value = $(cf).find('.radio-selector-cfield').val();
              }
              break;
            case 'date':
              value = $(cf).find('.input-date-cfield').val();
          }
          cfObj = {
            label: window.html_entities($(cf).attr('data-label')),
            value: window.html_entities(value),
            type: type
          };
          return task.CustomField.push(cfObj);
        });
        event = new EventModel();
        event.on('change', this.__refresh_and_change_page, this);
        return event.save_task(task);
      }

      btnDeleteTaskClicked(event) {
        var request;
        event.preventDefault();
        event.stopPropagation();
        request = new Object();
        request.sessionID = this.usr.get('sessionID');
        request.bookingID = this.task.get('Booking').bookingID;
        request.bookingLineID = this.task.get('Booking').bookingLineID;
        request.day = this.dateSelected.format('YYYY-MM-DD');
        this.task.delete_event(request);
        return $.mobile.jqmNavigator.popToFirst({
          transition: 'none'
        });
      }

      __refresh_and_change_page(event) {
        var conflict, found, i, index, len, popUp, popUpHtml, ref, ref1, view;
        if (event.get('EventCommitConflicts')) {
          conflict = event.get('EventCommitConflicts');
          popUpHtml = '<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" class="ui-corner-all"> <div data-role="header" data-theme="a" class="ui-corner-top"> <h3>Warning saving booking</h3> </div> <div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">';
          popUpHtml += `<p>${conflict.header}</p><p>Conflicts with: ${conflict.Conflict.header}</p>`;
          popUpHtml += '<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpDismiss">Dismiss</a> </div></div>';
          this.$el.append(popUpHtml);
          popUp = this.$el.find('#popupAlert');
          popUp.popup();
          popUp.trigger('create');
          popUp.popup('open');
          $.mobile.loading('show');
          return setTimeout(() => {
            $.mobile.loading('hide');
            this.eventsCol.set_day_events(this.usr, event.get('day'));
            return $.mobile.jqmNavigator.popToFirst({
              transition: 'none'
            });
          }, 5000);
        } else {
          if (!this.obj) {
            this.eventsCol.set_day_events(this.usr, event.get('day'));
            return $.mobile.jqmNavigator.popToFirst({
              transition: 'none'
            });
          } else {
            this.eventsCol.set_day_events(this.usr, event.get('day'), this.obj);
            index = 0;
            found = false;
            ref = $.mobile.jqmNavigator.getViews();
            for (i = 0, len = ref.length; i < len; i++) {
              view = ref[i];
              if ((ref1 = $(view.el).attr('id')) === 'id-EventListView' || ref1 === 'id-EventSheetView' || ref1 === 'id-EventDayPlan') {
                found = true;
                break;
              }
              index++;
            }
            if (!found) {
              index = 0;
            }
            return $.mobile.jqmNavigator.popToView(index, {
              transition: 'none'
            });
          }
        }
      }

      //TODO REFACTOR - UGLY DUPLICATED CODE IN CONTACT LIST (FORMPROJECT - CRUD BOOKING )
      addedProjectCfieldContact(view, contact) {
        var btn, obj;
        //liCfield = view.$el.find('.btn-contact-cfield[data-selected="true"]').closest('li').index()
        view.comingFromView = 'ContactSelector';
        $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
        btn = view.$el.find('.btn-contact-cfield[data-selected="true"]');
        if (btn.length === 0) {
          btn = view.$el.find('.btn-contact-cfield');
        }
        obj = contact.get('Contact');
        //SINCE PAGE SHOWN EVENT, LIST WAS REPRINTED
        //btn = view.$el.find('#id-ul-formproject-cfields li').eq(liCfield).find('.btn-contact-cfield')
        btn.find('.ui-btn-text').text(obj.firstName + ' ' + obj.lastName);
        btn.attr('data-contactID', obj.contactID);
        btn.attr('data-selected', false);
        return btn.button();
      }

      //BACk BUTTON
      btnBackClicked() {
        event.stopPropagation();
        event.preventDefault();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      __set_involved_times(allDay, timeIn, timeOut) {
        _.each(this.$el.find('.liBookingInvolved'), function(li) {
          $(li).attr('data-timeIn', timeIn);
          return $(li).attr('data-timeOut', timeOut);
        });
        _.each(this.$el.find('.slider-involved-allday'), function(slider) {
          if (allDay) {
            $(slider).val("on");
            $(slider).siblings('.wrapper-btn-time').hide();
          } else {
            $(slider).val("off");
            $(slider).siblings('.wrapper-btn-time').show();
          }
          return $(slider).slider('refresh');
        });
        _.each(this.$el.find('.input-involved-timein'), function(ti) {
          return $(ti).val(timeIn);
        });
        _.each(this.$el.find('.input-involved-timeout'), function(to) {
          return $(to).val(timeOut);
        });
        _.each(this.$el.find('.btn-timeIN-involved'), function(ti) {
          if (allDay) {
            return $(ti).text('Time In');
          } else {
            return $(ti).text('Time In: ' + timeIn);
          }
        });
        _.each(this.$el.find('.btn-timeOUT-involved'), function(to) {
          if (allDay) {
            return $(to).text('Time Out');
          } else {
            return $(to).text('Time Out: ' + timeOut);
          }
        });
        return _.each(this.$el.find('.spanTimeEventInvolved'), function(span) {
          if (allDay) {
            return $(span).text("All Day");
          } else {
            return $(span).html(`<span>${timeIn}</span> / <span>${timeOut}</span>`);
          }
        });
      }

      __set_cfields_tab(taskName) {
        var cfields, obj, ref;
        if (!taskName) {
          obj = this.task.get('Booking');
        } else {
          obj = (ref = _.where(this.taskList, {
            name: taskName
          })) != null ? ref[0] : void 0;
        }
        if (obj != null ? obj.CustomField : void 0) {
          //BUTON ENABLED
          this.$el.find('#id-submenu-addtask-cfields').removeClass('ui-disabled');
          //CUSTOM FIELDS PRINTING
          this.$el.find('#id-ul-addtask-cfields').empty();
          cfields = obj.CustomField;
          if (!_.isArray(cfields)) {
            cfields = [obj.CustomField];
          }
          if (!CustomFieldView) {
            CustomFieldView = require("views/cfield/CustomFieldView");
          }
          _.each(cfields, (cf) => {
            var cfLi;
            cfLi = new CustomFieldView(this.usr, cf, 'form').render().el;
            //li = @$el.find('<li>').append(form)
            return this.$el.find('#id-ul-addtask-cfields').append(cfLi);
          });
          /* UPDATING DOM STYLE */
          this.$el.find('#id-divAddTaskCFields').trigger('create');
        } else {
          this.$el.find('#id-submenu-addtask-cfields').addClass('ui-disabled');
        }
        this.$el.find('#id-ul-addtask-cfields').listview();
        return this.$el.find('#id-ul-addtask-cfields').listview('refresh');
      }

      //HELPERS FOR REQUEST NAME FORM
      __go_to_request_form(taskName) {
        if (taskName !== 'status') {
          this.__set_cfields_tab(taskName);
        }
        this.$el.find('#id-namerequest-form').hide();
        this.$el.find('.form-request-component').hide();
        this.$el.find('#id-task-status-form').hide();
        this.$el.find('#id-task-checkpoint-form').hide();
        this.$el.find('#id-addrequest-form').show();
        //BUTTONS CONTROL
        this.$el.find('#id-btn-done-name').hide();
        //@$el.find('#id-btn-done-task-status').hide()
        return this.$el.find('#id-btn-save-task').show();
      }

      __go_to_name_form(params) {
        this.$el.find('#id-addrequest-form').hide();
        this.$el.find('#id-namerequest-form').show();
        //BUTTONS CONTROL
        this.$el.find('#id-btn-done-name').show();
        return this.$el.find('#id-btn-save-task').hide();
      }

      __go_to_status_form(params) {
        this.$el.find('#id-addrequest-form').hide();
        this.$el.find('#id-task-stage-form').show();
        //BUTTONS CONTROL
        //@$el.find('#id-btn-done-task-status').show()
        return this.$el.find('#id-btn-save-task').hide();
      }

      __go_to_stage_form(params) {
        this.$el.find('#id-addrequest-form').hide();
        this.$el.find('#id-task-checkpoint-form').show();
        //BUTTONS CONTROL
        //@$el.find('#id-btn-done-task-status').show()
        return this.$el.find('#id-btn-save-task').hide();
      }

      __generate_legend_html(mdl) {
        var booking, curDate, curIndex, dateIn, dateOut, day;
        day = this.dateSelected.format('YYYY-MM-DD');
        if (mdl instanceof EventModel) {
          booking = mdl.get('Booking');
        } else {
          booking = mdl.Booking;
        }
        if (_.isArray(booking != null ? booking.occursOnDay : void 0)) {
          dateIn = Moment(booking.occursOnDay[0], 'YYYY-MM-DD');
          dateOut = Moment(booking.occursOnDay[booking.occursOnDay.length - 1], 'YYYY-MM-DD');
          curDate = Moment(day, 'YYYY-MM-DD');
          curIndex = curDate.diff(dateIn, 'days') + 1;
          return dateIn.format('dddd Do MMMM') + ' - ' + dateOut.format('dddd Do MMMM') + '(' + curIndex + '/' + (dateOut.diff(dateIn, 'days') + 1) + ')';
        } else {
          return 'Number of Occurrencies';
        }
      }

    };
  });

}).call(this);
